package org.msh.tb.bd.tbforms.dhis2.tb12;

import org.msh.tb.bd.entities.enums.SmearStatus;
import org.msh.tb.entities.enums.CaseState;
import org.msh.tb.entities.enums.Gender;
import org.msh.tb.entities.enums.PatientType;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Mauricio on 22/04/2017.
 * Mock data for each block of Tb 12 Form.
 * Used to test if all data elements and COCs Ids are correct.
 * To run this test need to change code on TB11AsyncTask to use the mock data generated by this class.
 */
public class TB12MockDataResource {

    private static final PatientType[] prevPts = new PatientType[]{
            PatientType.RELAPSE,
            PatientType.TREATMENT_AFTER_FAILURE,
            PatientType.TREATMENT_AFTER_LOSS_FOLLOW_UP,
            PatientType.OTHER_PREVIOUSLY_TREATED,
    };

    private static final Object[] columns = new Object[]{
            SmearStatus.SMEAR_NEGATIVE,
            SmearStatus.SMEAR_POSITIVE,
            CaseState.DIED,
            CaseState.FAILED,
            CaseState.DEFAULTED,
            CaseState.TRANSFERRED_OUT,
            CaseState.NOT_EVALUATED
    };

    public static List<Object[]> getMockResult(Long initCount, boolean setAsZero) {
        Object[] res;
        Long count = initCount;
        List<Object[]> results = new ArrayList<Object[]>();

        for (Object o : columns){
            int type = o instanceof SmearStatus ? 0 : 1;

            res = new Object[]{type,
                    PatientType.NEW,
                    null,
                    Gender.MALE,
                    o,
                    setAsZero ? new Long(0) : count
            };
            results.add(res);
            count = count+1;

            res = new Object[]{type,
                    PatientType.NEW,
                    null,
                    Gender.FEMALE,
                    o,
                    setAsZero ? new Long(0) : count
            };
            results.add(res);
            count = count+1;
        }

        for (PatientType prevPt: prevPts) {
            for (Object o : columns) {
                int type = o instanceof SmearStatus ? 0 : 1;

                res = new Object[]{type,
                        PatientType.PREVIOUSLY_TREATED,
                        prevPt,
                        Gender.MALE,
                        o,
                        setAsZero ? new Long(0) : count
                };
                results.add(res);
                count = count+1;

                res = new Object[]{type,
                        PatientType.PREVIOUSLY_TREATED,
                        prevPt,
                        Gender.FEMALE,
                        o,
                        setAsZero ? new Long(0) : count
                };
                results.add(res);
                count = count+1;
            }
        }

        return results;
    }
}
